package gov.va.genisis2.ts.objectmapper;

import java.io.IOException;

import org.owasp.esapi.ESAPI;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * Custom serializer used to escape html characters sent to the
 * web browser via JSON
 * @author Michael Edoror
 *
 */
public class EscapeHtmlSerializer extends JsonSerializer<String>{

    @Override
    public void serialize(String property, 
                          JsonGenerator jsonGenerator, 
                          SerializerProvider serializerProvider) 
                          throws IOException, JsonProcessingException {
        jsonGenerator.writeObject(
        		ESAPI.encoder().encodeForHTML(property));
    }
}
